/* FILE: msudsini.c                             (D. Tottingham  12/27/89)

This is a collection of routines that initialize suds structures.
The program has been written and compiled medium model.  The following public
functions are defined in this file:

suds_initialize ()              initialize a suds structure
suds_initialize_tag ()          initialize a suds structtag

EXTERNAL FUNCTIONS CALLED:

u_strcpy ()                     copies far string2 to far string1

HISTORY:
   none



/*************************************************************************
                             INCLUDE FILES


*************************************************************************/
#include <stdlib.h>
#include <string.h>

#include "mconst.h"
#include "msudsini.h"
#include "mutils.h"


/*************************************************************************
                                GLOBALS


*************************************************************************/
PRIVATE struct {
   LG_INT  fstype;           /* Structure types or identifiers               */
   SH_INT  ftype;            /* Type of variable in field                    */
   LG_INT  flength;          /* Length of variable in the field              */
   LG_INT  offset;           /* Offset of variable pointer from beginning of
                                structure measured in bytes, where first byte
                                of structure=0.                              */
   STRING  *initval;         /* Value to initialize structure                */
   LG_INT  nextfstype;       /* If structure, this is fstype                 */
} initializer[] = {
   NO_STRUCT,   STR,    1,      0,      NOSTRG, 0,
/*1*/
   ATODINFO,    SHT,    1,      0,      NODATA, 0,
   ATODINFO,    SHT,    1,      2,      NODATA, 0,
   ATODINFO,    SHT,    1,      4,      NODATA, 0,
   ATODINFO,    SHT,    1,      6,      NODATA, 0,
   ATODINFO,    SHT,    1,      8,      NODATA, 0,
   ATODINFO,    CHR,    1,      12,     NOCHAR, 0,
   ATODINFO,    CHR,    1,      13,     NOCHAR, 0,
/*8*/
   COMMENT,     SHT,    1,      0,      NODATA, 0,
   COMMENT,     SHT,    1,      2,      NODATA, 0,
   COMMENT,     SHT,    1,      4,      NODATA, 0,
   COMMENT,     SHT,    1,      6,      NODATA, 0,
/*12*/
   DESCRIPTRACE,STI,    1,      0,      NOSTRG, STAT_IDENT,
   DESCRIPTRACE,MST,    1,      12,     NOTIME, 0,
   DESCRIPTRACE,SHT,    1,      20,     NODATA, 0,
   DESCRIPTRACE,CHR,    1,      22,     NOCHAR, 0,
   DESCRIPTRACE,CHR,    1,      23,     NOCHAR, 0,
   DESCRIPTRACE,SHT,    1,      24,     NOLIST, 0,
   DESCRIPTRACE,SHT,    1,      26,     NOLIST, 0,
   DESCRIPTRACE,LNG,    1,      28,     NODATA, 0,
   DESCRIPTRACE,FLT,    1,      32,     NODATA, 0,
   DESCRIPTRACE,FLT,    1,      36,     NODATA, 0,
   DESCRIPTRACE,FLT,    1,      40,     NODATA, 0,
   DESCRIPTRACE,FLT,    1,      44,     NODATA, 0,
   DESCRIPTRACE,LNG,    1,      48,     NODATA, 0,
   DESCRIPTRACE,MST,    1,      52,     NOTIME, 0,
   DESCRIPTRACE,FLT,    1,      60,     NODATA, 0,
/*27*/
   DETECTOR,    CHR,    1,      0,      NOCHAR, 0,
   DETECTOR,    CHR,    1,      1,      NOCHAR, 0,
   DETECTOR,    STR,    10,     2,      NOSTRG, 0,
   DETECTOR,    FLT,    1,      12,     NODATA, 0,
   DETECTOR,    LNG,    1,      16,     NODATA, 0,
   DETECTOR,    LNG,    1,      20,     NODATA, 0,
/*33*/
   EVENTSETTING,STR,    4,      0,      NOSTRG, 0,
   EVENTSETTING,MST,    1,      4,      NOTIME, 0,
   EVENTSETTING,SHT,    1,      12,     NODATA, 0,
   EVENTSETTING,SHT,    1,      14,     NODATA, 0,
   EVENTSETTING,SHT,    1,      16,     NODATA, 0,
   EVENTSETTING,SHT,    1,      18,     NODATA, 0,
   EVENTSETTING,FLT,    1,      20,     NODATA, 0,
   EVENTSETTING,FLT,    1,      24,     NODATA, 0,
   EVENTSETTING,CHR,    1,      28,     NOCHAR, 0,
   EVENTSETTING,CHR,    1,      29,     NOCHAR, 0,
   EVENTSETTING,SHT,    1,      30,     NODATA, 0,
/*44*/
   FEATURE,     STI,    1,      0,      NOSTRG, STAT_IDENT,
   FEATURE,     SHT,    1,      12,     NOLIST, 0,
   FEATURE,     CHR,    1,      14,     NOCHAR, 0,
   FEATURE,     CHR,    1,      15,     NOCHAR, 0,
   FEATURE,     SHT,    1,      16,     NODATA, 0,
   FEATURE,     CHR,    1,      18,     NOCHAR, 0,
   FEATURE,     CHR,    1,      19,     NOCHAR, 0,
   FEATURE,     CHR,    1,      20,     NOCHAR, 0,
   FEATURE,     CHR,    1,      21,     NOCHAR, 0,
   FEATURE,     SHT,    1,      22,     NODATA, 0,
   FEATURE,     MST,    1,      24,     NOTIME, 0,
   FEATURE,     FLT,    1,      32,     NODATA, 0,
   FEATURE,     FLT,    1,      36,     NODATA, 0,
   FEATURE,     STT,    1,      40,     NOTIME, 0,
   FEATURE,     SHT,    1,      44,     NODATA, 0,
   FEATURE,     SHT,    1,      46,     NODATA, 0,
/*60*/
   MUXDATA,     STR,    4,      0,      "unk",  0,
   MUXDATA,     MST,    1,      4,      NOTIME, 0,
   MUXDATA,     SHT,    1,      12,     NODATA, 0,
   MUXDATA,     SHT,    1,      14,     NODATA, 0,
   MUXDATA,     FLT,    1,      16,     NODATA, 0,
   MUXDATA,     CHR,    1,      20,     NOCHAR, 0,
   MUXDATA,     CHR,    1,      21,     NOCHAR, 0,
   MUXDATA,     SHT,    1,      22,     NODATA, 0,
   MUXDATA,     LNG,    1,      24,     NODATA, 0,
   MUXDATA,     LNG,    1,      28,     NODATA, 0,
/*70*/
   ORIGIN,      LNG,    1,      0,      NODATA, 0,
   ORIGIN,      SHT,    1,      4,      NOLIST, 0,
   ORIGIN,      CHR,    1,      6,      NOCHAR, 0,
   ORIGIN,      CHR,    1,      7,      NOCHAR, 0,
   ORIGIN,      CHR,    1,      8,      NOCHAR, 0,
   ORIGIN,      CHR,    1,      9,      NOCHAR, 0,
   ORIGIN,      CHR,    1,      10,     NOCHAR, 0,
   ORIGIN,      CHR,    1,      11,     NOCHAR, 0,
   ORIGIN,      LNG,    1,      12,     NODATA, 0,
   ORIGIN,      MST,    1,      16,     NOTIME, 0,
   ORIGIN,      LLT,    1,      24,     NODATA, 0,
   ORIGIN,      LLT,    1,      32,     NODATA, 0,
   ORIGIN,      FLT,    1,      40,     NODATA, 0,
   ORIGIN,      FLT,    1,      44,     NODATA, 0,
   ORIGIN,      FLT,    1,      48,     NODATA, 0,
   ORIGIN,      FLT,    1,      52,     NODATA, 0,
   ORIGIN,      STR,    6,      56,     NOSTRG, 0,
   ORIGIN,      SHT,    1,      62,     NODATA, 0,
   ORIGIN,      FLT,    1,      64,     NODATA, 0,
   ORIGIN,      SHT,    1,      68,     NODATA, 0,
   ORIGIN,      SHT,    1,      70,     NODATA, 0,
   ORIGIN,      SHT,    1,      72,     NODATA, 0,
   ORIGIN,      SHT,    1,      74,     NODATA, 0,
   ORIGIN,      SHT,    1,      76,     NODATA, 0,
   ORIGIN,      SHT,    1,      78,     NODATA, 0,
   ORIGIN,      SHT,    1,      80,     NODATA, 0,
   ORIGIN,      SHT,    1,      82,     NODATA, 0,
   ORIGIN,      FLT,    1,      84,     NODATA, 0,
   ORIGIN,      FLT,    1,      88,     NODATA, 0,
   ORIGIN,      FLT,    1,      92,     NODATA, 0,
   ORIGIN,      STT,    1,      96,     NOTIME, 0,
/*101*/
   STAT_IDENT,  STR,    4,      0,      "unk",  0,
   STAT_IDENT,  STR,    5,      4,      NOSTRG, 0,
   STAT_IDENT,  CHR,    1,      9,      NOCHAR, 0,
   STAT_IDENT,  SHT,    1,      10,     NOLIST, 0,
/*105*/
   STATIONCOMP, STI,    1,      0,      NOSTRG, STAT_IDENT,
   STATIONCOMP, SHT,    1,      12,     NODATA, 0,
   STATIONCOMP, SHT,    1,      14,     NODATA, 0,
   STATIONCOMP, LLT,    1,      16,     NODATA, 0,
   STATIONCOMP, LLT,    1,      24,     NODATA, 0,
   STATIONCOMP, FLT,    1,      32,     NODATA, 0,
   STATIONCOMP, CHR,    1,      36,     NOCHAR, 0,
   STATIONCOMP, MIN,    1,      37,     NOLIST, 0,
   STATIONCOMP, CHR,    1,      38,     NOCHAR, 0,
   STATIONCOMP, CHR,    1,      39,     NOCHAR, 0,
   STATIONCOMP, SHT,    1,      40,     NOLIST, 0,
   STATIONCOMP, CHR,    1,      42,     NOCHAR, 0,
   STATIONCOMP, CHR,    1,      43,     NOCHAR, 0,
   STATIONCOMP, CHR,    1,      44,     NOCHAR, 0,
   STATIONCOMP, CHR,    1,      45,     NOCHAR, 0,
   STATIONCOMP, CHR,    1,      46,     NOCHAR, 0,
   STATIONCOMP, MIN,    1,      47,     NOLIST, 0,
   STATIONCOMP, FLT,    1,      48,     NODATA, 0,
   STATIONCOMP, FLT,    1,      52,     NODATA, 0,
   STATIONCOMP, FLT,    1,      56,     NODATA, 0,
   STATIONCOMP, SHT,    1,      60,     NODATA, 0,
   STATIONCOMP, SHT,    1,      62,     NODATA, 0,
   STATIONCOMP, STT,    1,      64,     NOTIME, 0,
   STATIONCOMP, FLT,    1,      68,     NODATA, 0,
   STATIONCOMP, FLT,    1,      72,     NODATA, 0,
/*130*/
   STRUCTTAG,   CHR,    1,      0,         "S", 0,
   STRUCTTAG,   CHR,    1,      1,     MACHINE, 0,
   STRUCTTAG,   SHT,    1,      2,      NODATA, 0,
   STRUCTTAG,   LNG,    1,      4,      NODATA, 0,
/*134*/
   TIMECORRECTION, STI, 1,      0,      NOSTRG, STAT_IDENT,
   TIMECORRECTION, MST, 1,      12,     NOTIME, 0,
   TIMECORRECTION, FLT, 1,      20,     NODATA, 0,
   TIMECORRECTION, CHR, 1,      24,     NOCHAR, 0,
   TIMECORRECTION, CHR, 1,      25,     NOCHAR, 0,
   TIMECORRECTION, STT, 1,      26,     NOTIME, 0,
   TIMECORRECTION, SHT, 1,      30,     NODATA, 0,
/*141*/
   TRIGGERS,    STI,    1,      0,      NOSTRG, STAT_IDENT,
   TRIGGERS,    SHT,    1,      12,     NODATA, 0,
   TRIGGERS,    SHT,    1,      14,     NODATA, 0,
   TRIGGERS,    SHT,    1,      16,     NODATA, 0,
   TRIGGERS,    SHT,    1,      18,     NODATA, 0,
   TRIGGERS,    SHT,    1,      20,     NODATA, 0,
   TRIGGERS,    SHT,    1,      22,     NODATA, 0,
   TRIGGERS,    MST,    1,      24,     NOTIME, 0,
/*149*/
   TRIGSETTING, STR,    4,      0,       "unk", 0,
   TRIGSETTING, MST,    1,      4,      NOTIME, 0,
   TRIGSETTING, SHT,    1,      12,     NODATA, 0,
   TRIGSETTING, SHT,    1,      14,     NODATA, 0,
   TRIGSETTING, SHT,    1,      16,     NODATA, 0,
   TRIGSETTING, SHT,    1,      18,     NODATA, 0,
   TRIGSETTING, SHT,    1,      20,     NODATA, 0,
   TRIGSETTING, SHT,    1,      22,     NODATA, 0,
   TRIGSETTING, FLT,    1,      24,     NODATA, 0,
   TRIGSETTING, FLT,    1,      28,     NODATA, 0,
   TRIGSETTING, CHR,    1,      32,     NOCHAR, 0,
   TRIGSETTING, CHR,    1,      33,     NOCHAR, 0,
   TRIGSETTING, SHT,    1,      34,     NODATA, 0
/*162*/
};

PRIVATE unsigned int structure_offset[]={
/* 0,  1,   2, 3, 4,  5,  6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,  25,  26, 27, 28, 29, 30, 31 */
   0,101, 130, 0, 0,105, 60,12, 0, 0, 44,  0,  0,  0, 70,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0, 141, 149, 33, 27,  1,134, 0
};

PRIVATE unsigned int structure_size[]={
/*  0 */        0,
/*  1 */        sizeof(SUDS_STATIDENT),
/*  2 */        sizeof(SUDS_STRUCTTAG),
/*  3 */        0,
/*  4 */        0,
/*  5 */        sizeof(SUDS_STATIONCOMP),
/*  6 */        sizeof(SUDS_MUXDATA),
/*  7 */        sizeof(SUDS_DESCRIPTRACE),
/*  8 */        0,
/*  9 */        0,
/* 10 */        sizeof(SUDS_FEATURE),
/* 11 */        0,
/* 12 */        0,
/* 13 */        0,
/* 14 */        sizeof(SUDS_ORIGIN),
/* 15 */        0,
/* 16 */        0,
/* 17 */        0,
/* 18 */        0,
/* 19 */        0,
/* 20 */        sizeof(SUDS_COMMENT),
/* 21 */        0,
/* 22 */        0,
/* 23 */        0,
/* 24 */        0,
/* 25 */        sizeof(SUDS_TRIGGERS),
/* 26 */        sizeof(SUDS_TRIGSETTING),
/* 27 */        sizeof(SUDS_EVENTSETTING),
/* 28 */        sizeof(SUDS_DETECTOR),
/* 29 */        sizeof(SUDS_ATODINFO),
/* 30 */        sizeof(SUDS_TIMECORRECTION),
/* 31 */        0
};


/*=======================================================================*
 *                            initialize_value                           *
 *=======================================================================*/
/* Initialize a suds value.                                              */

PRIVATE
void initialize_value (i, ptr)
int i;
void far * ptr;
{
   char far * farstring;

   switch(initializer[i].ftype) {
      case CHR:
         *((char far *)ptr) = initializer[i].initval[0];
         break;
      case BTS:
      case MIN:
         *((char far *)ptr) = atoi(initializer[i].initval);
         break;
      case STR:
         farstring = (char far *) initializer[i].initval;
         u_strcpy (((char far *)ptr), farstring);
         break;
      case SHT:
         *((short far *)ptr) = atoi(initializer[i].initval);
         break;
      case LNG:
         *((long far *)ptr) = atoi(initializer[i].initval);
         break;
      case FLT:
         *((float far *)ptr) = atof(initializer[i].initval);
         break;
      case LLT:
      case DBL:
         *((double far *)ptr) = atof(initializer[i].initval);
         break;
      case STT:
         *((ST_TIME far *)ptr) = atoi(initializer[i].initval);
         break;
      case MST:
         *((MS_TIME far *)ptr) = atof(initializer[i].initval);
         break;
      case BTW:
         *((unsigned short far *)ptr) = atoi(initializer[i].initval);
         break;
      case CAL:
      case CPX:
      case STI:
      default:
         break;
   }
}

/*=======================================================================*
 *                            suds_initialize                            *
 *=======================================================================*/
/* Initialize a suds structure.                                          */

PUBLIC
void suds_initialize (type, ptr)
unsigned int type;
void far * ptr;
{
   register unsigned int i;

   for (i = structure_offset[type]; initializer[i].fstype==type; i++) {
      if (initializer[i].nextfstype != 0) {
         suds_initialize (initializer[i].nextfstype, ((char far *)ptr)+initializer[i].offset);
      } else initialize_value (i, ((char far *)ptr)+initializer[i].offset);
   }
}

/*=======================================================================*
 *                          suds_initialize_tag                          *
 *=======================================================================*/
/* Initialize a suds structtag.                                          */

PUBLIC
void suds_initialize_tag (type, ptr)
unsigned int type;
SUDS_STRUCTTAG far * ptr;
{
   suds_initialize (STRUCTTAG, ptr);
   ptr->id_struct = type;
   ptr->len_struct = structure_size[type];
   ptr->len_data = 0;
}
